<?php

namespace Merchant\Entities;

use Illuminate\Database\Eloquent\Model;

class ContractRestdayTable extends Model 
{

    protected $table = 'contract_restday_tables';
    public $timestamps = true;
    protected $fillable = array('name', 'year');
    protected $visible = array('name', 'year');

    public function contract()
    {
        return $this->belongsTo('EmployeeContract', 'contract_id', 'id');
    }

    public function restdays()
    {
        return $this->hasMany('ContractRestday');
    }

}